**********************************************************************
* Duncan Amplfication Generic Triode Model (PSpice Implementation)
* Copyright (C)1997-2004 Duncan Amplfication
* Unauthorised Commercial use prohibited
* Please refer to documentation at http://www.duncanamps.com
*
* $MODEL_VERSION$ 4.1
* $AUTOGENERATED$ 23/01/2004 20:24:26 
**********************************************************************
* CURRENT MODEL SET AND VERSIONS:
*
*       2A3                 [3.2, 09/08/2003 ]
*       3CX300              [3.1, 05/01/1998 ]
*       SV6AS7              [3.0, 30/12/1997 ]
*       6BM8 / ECL82        [3.0, 31/12/1997 ]
*       6DJ8 / ECC88        [3.0, 15/08/1998 ]
*       6N1P                [3.0, 25/01/1998 ]
*       6SN7GTB             [3.1, 05/01/1998 ]
*       12AT7 / ECC81       [3.1, 05/01/1998 ]
*       12AU7 / ECC82       [3.2, 01/05/2002 ]
*       12AX7 / ECC83       [3.0, 30/12/1997 ]
*       76                  [3.0, 12/02/1998 ]
*       300B                [3.1, 06/01/1998 ]
*       SV572-3             [3.0, 31/12/1997 ]
*       SV572-10            [3.0, 20/06/1998 ]
*       5751                [3.0, 15/02/1998 ]
**********************************************************************
* CORE MODEL VERSION HISTORY:
*
*       1.0   23/09/1997    Initial model
*       1.1   19/11/1997    Model altered for 1 gig resistors between each node and ground
*       2.0   18/12/1997    Two new parameters, ERP and ERI added
*       3.0   30/12/1997    New parameter added, RAS
*       3.1   05/01/1998    ERI parameter removed
*       3.2   06/01/1998    Fix errors in Pspice model
*       3.3   13/01/1998    Fixed errors with CDO parameter
*       3.4   25/01/1998    Errors with heater versions using ERI  fixed
*       4.1   23/01/2004    Corrections to Pspice syntax for LTSpice
**********************************************************************
.SUBCKT TRIODE A G K H1 H2
+PARAMS: RCO=1.6 RHO=10.5 HTV=6.3 HWU=10.5
+ LIP=1 LIF=3.7E-3 RAF=18E-3 RAS=1 CDO=0 RAP=4E-3
+ ERP=1.5 
+ MU0=17.3 MUR=19E-3 EMC=9.6E-6 GCO=0 GCF=213E-6
+ CGA=3.9p CGK=2.4p CAK=0.7p 

************************************************************************
*
* Heater model
*
* Can be operated from AC or DC power sources.
* NB: When operating from DC power sources, "Skip initial transient
*     solution" must be checked, to make use of this model.
*
* PARAMETERS
*
*	RCO Heater resistance cold (ohms)
*	RHO Heater resistance hot (ohms)
*	HTV Normal heater voltage (V)
* 	HWU Heater time to warm up to 90% of emission (seconds)
*
************************************************************************

Rcool H1 HA {RCO}
Rload HA HB 1M
Esens HD 0  VALUE {V(HA,HB)*1000}
Epwr  HE 0  VALUE {V(H1,H2)*V(HD)/(PWR({HTV},2)/{RHO})}
RH1   HE HF 91k
CH1   HF 0  {HWU/1E6}
EH2   HG 0  VALUE {V(HF)}
RH2   HG HH 270k
CH2   HH 0  {HWU/1E6}
EH3   HJ 0  VALUE {LIMIT(V(HH)-0.75,0,1E6)*4}
RH3   HJ HK 91k
CH3   HK 0  {HWU/1E6}
Ghot  HB H2 VALUE {(1/(V(HG)+0.001))/({RHO}-{RCO})*V(HB,H2)}

************************************************************************
*
* Anode/grid model
*
* Models reduction in mu at large negative grid voltages
* Models change in Ra with negative grid voltages
* Models limit in Ia with high +Vg and low Va
*
* PARAMETERS
*
*	LIP Conduction limit exponent
*	LIF Conduction limit factor
*	CDO Conduction offset
*	RAF Anode resistance factor for neg grid voltages
*	RAP Anode resistance factor for positive grid voltages
*	ERP Emission power
*	MU0 Mu between grid and anode at Vg=0
*	MUR Mu reduction factor for large negative grid voltages
*	EMC Emission coefficient
*	GCO Grid current offset in volts
*	GCF Grid current scale factor
*
************************************************************************

Elim  LI 0  VALUE {PWR(LIMIT(V(A,K),0,1E6),{LIP})*{LIF}}
Egg   GG 0  VALUE {V(G,K)-{CDO}}
Erpf  RP 0  VALUE {1-PWR(LIMIT(-V(GG)*{RAF},0,0.999),{RAS})+LIMIT(V(GG),0,1E6)*{RAP}}
Egr   GR 0  VALUE {LIMIT(V(GG),0,1E6)+LIMIT((V(GG))*(1+V(GG)*{MUR}),0,-1E6)}
Eem   EM 0  VALUE {LIMIT(V(A,K)+V(GR)*{MU0},0,1E6)}
Eep   EP 0  VALUE {PWR(V(EM),ERP)*{EMC}*V(RP)}
Eel   EL 0  VALUE {LIMIT(V(EP),0,V(LI))}
Eld   LD 0  VALUE {LIMIT(V(EP)-V(LI),0,1E6)}
Ga    A  K  VALUE {V(HK)*V(EL)}

************************************************************************
*
* Grid current model
*
* Models grid current, along with rise in grid current at low Va
*
************************************************************************
Egf   GF 0  VALUE {PWR(LIMIT(V(G,K)-{GCO},0,1E6),1.5)*{GCF}}
Gg    G  K  VALUE {(V(GF)+V(LD))*V(HK)}

*
* Capacitances and anti-float resistors
*
CM1	G	K	{CGK}
CM2	A	G	{CGA}
CM3	A	K	{CAK}
RF1	A	0	1000MEG
RF2	G	0	1000MEG
RF3	K	0	1000MEG

.ENDS

.SUBCKT TRIODENH A G K
+PARAMS: LIP=1 LIF=3.7E-3 RAF=18E-3 RAS=1 CDO=0 RAP=4E-3
+ ERP=1.5
+ MU0=17.3 MUR=19E-3 EMC=9.6E-6 GCO=0 GCF=213E-6
+ CGA=3.9p CGK=2.4p CAK=0.7p 

************************************************************************
*
* Anode/grid model
*
* Models reduction in mu at large negative grid voltages
* Models change in Ra with negative grid voltages
* Models limit in Ia with high +Vg and low Va
*
* PARAMETERS
*
*	LIP Conduction limit exponent
*	LIF Conduction limit factor
*	CDO Conduction offset
*	RAF Anode resistance factor for neg grid voltages
*	RAP Anode resistance factor for positive grid voltages
*	ERP Emission power
*	MU0 Mu between grid and anode at Vg=0
*	MUR Mu reduction factor for large negative grid voltages
*	EMC Emission coefficient
*	GCO Grid current offset in volts
*	GCF Grid current scale factor
*
************************************************************************

Elim  LI 0  VALUE {PWR(LIMIT(V(A,K),0,1E6),{LIP})*{LIF}}
Egg   GG 0  VALUE {V(G,K)-{CDO}}
Erpf  RP 0  VALUE {1-PWR(LIMIT(-V(GG)*{RAF},0,0.999),{RAS})+LIMIT(V(GG),0,1E6)*{RAP}}
Egr   GR 0  VALUE {LIMIT(V(GG),0,1E6)+LIMIT((V(GG))*(1+V(GG)*{MUR}),0,-1E6)}
Eem   EM 0  VALUE {LIMIT(V(A,K)+V(GR)*{MU0},0,1E6)}
Eep   EP 0  VALUE {PWR(V(EM),ERP)*{EMC}*V(RP)}
Eel   EL 0  VALUE {LIMIT(V(EP),0,V(LI))}
Eld   LD 0  VALUE {LIMIT(V(EP)-V(LI),0,1E6)}
Ga    A  K  VALUE {V(EL)}

************************************************************************
*
* Grid current model
*
* Models grid current, along with rise in grid current at low Va
*
************************************************************************
Egf   GF 0  VALUE {PWR(LIMIT(V(G,K)-{GCO},0,1E6),1.5)*{GCF}}
Gg    G  K  VALUE {(V(GF)+V(LD))}

*
* Capacitances and anti-float resistors
*
CM1	G	K	{CGK}
CM2	A	G	{CGA}
CM3	A	K	{CAK}
RF1	A	0	1000MEG
RF2	G	0	1000MEG
RF3	K	0	1000MEG

.ENDS
**********************************************************************
* GENERIC: 2A3
* MODEL:   NH2A3
* NOTES:   No heater model (virtual cathode)
**********************************************************************
.SUBCKT NH2A3 A G K
XV1 A G K TRIODENH
+PARAMS: LIP= 1.5 LIF= 0.003 RAF= 1.92357959289845E-02 RAS= 5.31355720568454E-02 CDO= 0 
+ RAP= 0.005 ERP= 1.55 
+ MU0= 4.2 MUR= 0.001023047 EMC= 0.0000868 
+ GCO=-0.2 GCF= 0.00001 
+ CGA=1.65E-11 CGK=7.50E-12 CAK=5.50E-12
.ENDS

**********************************************************************
* GENERIC: 3CX300
* MODEL:   NH3CX300
* NOTES:   No heater model
**********************************************************************
.SUBCKT NH3CX300 A G K
XV1 A G K TRIODENH
+PARAMS: LIP= 1.5 LIF= 10 RAF= 0.00536 RAS= 1 CDO= 0 
+ RAP= 0.005 ERP= 1.25 
+ MU0= 8.321 MUR= 0.0012 EMC= 0.000533 
+ GCO= 0 GCF= 0.0001 
+ CGA=1.00E-11 CGK=2.50E-11 CAK=1.00E-12
.ENDS

**********************************************************************
* GENERIC: SV6AS7
* MODEL:   NHSV6AS7
* NOTES:   No heater model
**********************************************************************
.SUBCKT NHSV6AS7 A G K
XV1 A G K TRIODENH
+PARAMS: LIP= 1 LIF= 0.01 RAF= 0.0058 RAS= 0.7 CDO= 0 
+ RAP= 0.035 ERP= 1.5 
+ MU0= 2.05 MUR= 0.0017 EMC= 0.0005 
+ GCO= 0 GCF= 0 
+ CGA=1.10E-11 CGK=8.00E-12 CAK=3.00E-12
.ENDS

**********************************************************************
* GENERIC: 6BM8 / ECL82
* MODEL:   NH6BM8
* NOTES:   No heater or grid model
**********************************************************************
.SUBCKT NH6BM8 A G K
XV1 A G K TRIODENH
+PARAMS: LIP= 1.5 LIF= 10 RAF= 0.030667 RAS= 5 CDO=-0.5 
+ RAP= 0.587 ERP= 1.5 
+ MU0= 50 MUR= 0.035 EMC= 0.00000256 
+ GCO= 0 GCF= 0 
+ CGA=4.00E-12 CGK=2.70E-12 CAK=4.00E-12
.ENDS

**********************************************************************
* GENERIC: 6DJ8 / ECC88
* MODEL:   NH6DJ8
* NOTES:   No heater or grid current model
**********************************************************************
.SUBCKT NH6DJ8 A G K
XV1 A G K TRIODENH
+PARAMS: LIP= 1.5 LIF= 10 RAF= 0.09 RAS= 0.2 CDO= 0 
+ RAP= 0 ERP= 1.35 
+ MU0= 33 MUR= 0.02 EMC= 0.0000795 
+ GCO=-0.2 GCF= 0 
+ CGA=1.40E-12 CGK=3.30E-12 CAK=1.80E-12
.ENDS

**********************************************************************
* GENERIC: 6N1P
* MODEL:   NH6N1P
* NOTES:   No heater/grid model
**********************************************************************
.SUBCKT NH6N1P A G K
XV1 A G K TRIODENH
+PARAMS: LIP= 1.5 LIF= 10 RAF= 0.01 RAS= 1 CDO= 0 
+ RAP= 0 ERP= 1.6 
+ MU0= 37.5 MUR= 0.01 EMC= 0.000005 
+ GCO= 0 GCF= 0 
+ CGA=1.60E-12 CGK=3.20E-12 CAK=1.50E-12
.ENDS

**********************************************************************
* GENERIC: 6SN7GTB
* MODEL:   6SN7GTB
* NOTES:   Has heater model (one half of heater)
**********************************************************************
.SUBCKT 6SN7GTB A G K H1 H2
XV1 A G K H1 H2 TRIODE
+PARAMS: RCO= 3.2 RHO= 21 HTV= 6.3 HWU= 10.5 
+ LIP= 1 LIF= 0.0037 RAF= 0.02 RAS= 2 CDO= 0 
+ RAP= 0.002 ERP= 1.4 
+ MU0= 19.2642 MUR= 0.006167 EMC= 0.0000189 
+ GCO= 0 GCF= 0.000213 
+ CGA=3.90E-12 CGK=2.40E-12 CAK=7.00E-13
.ENDS

**********************************************************************
* GENERIC: 6SN7GTB
* MODEL:   NH6SN7GTB
* NOTES:   No heater model
**********************************************************************
.SUBCKT NH6SN7GTB A G K
XV1 A G K TRIODENH
+PARAMS: LIP= 1 LIF= 0.0037 RAF= 0.02 RAS= 2 CDO= 0 
+ RAP= 0.002 ERP= 1.4 
+ MU0= 19.2642 MUR= 0.006167 EMC= 0.0000189 
+ GCO= 0 GCF= 0.000213 
+ CGA=3.90E-12 CGK=2.40E-12 CAK=7.00E-13
.ENDS

**********************************************************************
* GENERIC: 12AT7 / ECC81
* MODEL:   12AT7
* NOTES:   Heater model for one half of heater (6.3V)
**********************************************************************
.SUBCKT 12AT7 A G K H1 H2
XV1 A G K H1 H2 TRIODE
+PARAMS: RCO= 6.2 RHO= 42 HTV= 6.3 HWU= 10.5 
+ LIP= 1 LIF= 0.0037 RAF= 0.09869 RAS= 1 CDO=-0.5 
+ RAP= 0.1 ERP= 1.4 
+ MU0= 45.093 MUR= 0.012937 EMC= 0.00000863 
+ GCO=-0.5 GCF= 0.00012 
+ CGA=1.60E-12 CGK=2.30E-12 CAK=4.00E-13
.ENDS

**********************************************************************
* GENERIC: 12AT7 / ECC81
* MODEL:   NH12AT7
* NOTES:   No heater model
**********************************************************************
.SUBCKT NH12AT7 A G K
XV1 A G K TRIODENH
+PARAMS: LIP= 1 LIF= 0.0037 RAF= 0.09869 RAS= 1 CDO=-0.5 
+ RAP= 0.1 ERP= 1.4 
+ MU0= 45.093 MUR= 0.012937 EMC= 0.00000863 
+ GCO=-0.5 GCF= 0.00012 
+ CGA=1.60E-12 CGK=2.30E-12 CAK=4.00E-13
.ENDS

**********************************************************************
* GENERIC: 12AU7 / ECC82
* MODEL:   12AU7
* NOTES:   Heater model for one half of heater (6.3V)
**********************************************************************
.SUBCKT 12AU7 A G K H1 H2
XV1 A G K H1 H2 TRIODE
+PARAMS: RCO= 6.2 RHO= 42 HTV= 6.3 HWU= 10.5 
+ LIP= 1 LIF= 0.0037 RAF= 0.024778659 RAS= 2.040491735 CDO= 0 
+ RAP= 0.18 ERP= 1.35 
+ MU0= 14.27427 MUR= 0.005857103 EMC= 0.0000236 
+ GCO= 0 GCF= 0.00012 
+ CGA=1.60E-12 CGK=1.80E-12 CAK=4.50E-13
.ENDS

**********************************************************************
* GENERIC: 12AU7 / ECC82
* MODEL:   NH12AU7
* NOTES:   No heater model
**********************************************************************
.SUBCKT NH12AU7 A G K
XV1 A G K TRIODENH
+PARAMS: LIP= 1 LIF= 0.0037 RAF= 0.000001 RAS= 2.065382774 CDO= 0 
+ RAP= 0.18 ERP= 1.4 
+ MU0= 17.08958652 MUR= 0.010938375 EMC= 0.0000183 
+ GCO= 0 GCF= 0.00012 
+ CGA=1.60E-12 CGK=1.80E-12 CAK=4.50E-13
.ENDS

**********************************************************************
* GENERIC: 12AX7 / ECC83
* MODEL:   12AX7
* NOTES:   Heater model for one half of heater (6.3V)
**********************************************************************
.SUBCKT 12AX7 A G K H1 H2
XV1 A G K H1 H2 TRIODE
+PARAMS: RCO= 6.2 RHO= 42 HTV= 6.3 HWU= 10.5 
+ LIP= 1.5 LIF= 0.000016 RAF= 0.076498 RAS= 1 CDO=-0.53056 
+ RAP= 0.18 ERP= 1.5 
+ MU0= 87.302 MUR=-0.013621 EMC= 0.00000111 
+ GCO=-0.2 GCF= 0.00001 
+ CGA=3.90E-12 CGK=2.40E-12 CAK=7.00E-13
.ENDS

**********************************************************************
* GENERIC: 12AX7 / ECC83
* MODEL:   NH12AX7
* NOTES:   No heater model
**********************************************************************
.SUBCKT NH12AX7 A G K
XV1 A G K TRIODENH
+PARAMS: LIP= 1.5 LIF= 0.000016 RAF= 0.076498 RAS= 1 CDO=-0.53056 
+ RAP= 0.18 ERP= 1.5 
+ MU0= 87.302 MUR=-0.013621 EMC= 0.00000111 
+ GCO=-0.2 GCF= 0.00001 
+ CGA=3.90E-12 CGK=2.40E-12 CAK=7.00E-13
.ENDS

**********************************************************************
* GENERIC: 76
* MODEL:   NH76
* NOTES:   No heater/grid model
**********************************************************************
.SUBCKT NH76 A G K
XV1 A G K TRIODENH
+PARAMS: LIP= 1 LIF= 10 RAF= 0.015 RAS= 1.8 CDO= 0 
+ RAP= 0 ERP= 1.6 
+ MU0= 12.8 MUR= 0.001 EMC= 0.000008 
+ GCO= 0 GCF= 0 
+ CGA=2.80E-12 CGK=3.50E-12 CAK=2.50E-12
.ENDS

**********************************************************************
* GENERIC: 300B
* MODEL:   NH300B
* NOTES:   No heater/grid model (virtual cathode)
**********************************************************************
.SUBCKT NH300B A G K
XV1 A G K TRIODENH
+PARAMS: LIP= 1 LIF= 10 RAF= 0.00311 RAS= 1.013608 CDO= 0 
+ RAP= 0 ERP= 1.5 
+ MU0= 3.7992 MUR= 0.000362 EMC= 0.000116 
+ GCO= 0 GCF= 0 
+ CGA=1.50E-11 CGK=9.00E-12 CAK=4.30E-12
.ENDS

**********************************************************************
* GENERIC: SV572-3
* MODEL:   SV5723
* NOTES:   No heater model (virtual cathode)
**********************************************************************
.SUBCKT SV5723 A G K
XV1 A G K TRIODENH
+PARAMS: LIP= 1 LIF= 0.0018 RAF= 0.0012 RAS= 0.5 CDO= 0 
+ RAP= 0 ERP= 1.4 
+ MU0= 3.79928 MUR= 0.0002 EMC= 0.0000425 
+ GCO= 0 GCF= 0.0000349 
+ CGA=4.00E-12 CGK=4.00E-12 CAK=1.00E-12
.ENDS

**********************************************************************
* GENERIC: SV572-10
* MODEL:   SV57210
* NOTES:   This model is not accurate for Vg >= +60V
**********************************************************************
.SUBCKT SV57210 A G K
XV1 A G K TRIODENH
+PARAMS: LIP= 1.4 LIF= 0.0008 RAF= 0.001 RAS= 1 CDO= 0 
+ RAP=-0.00117 ERP= 1.38 
+ MU0= 10 MUR= 0.0001 EMC= 0.0000272 
+ GCO=-0.2 GCF= 0.0003 
+ CGA=5.00E-12 CGK=6.40E-12 CAK=1.00E-12
.ENDS

**********************************************************************
* GENERIC: 5751
* MODEL:   NH5751
* NOTES:   No heater model
**********************************************************************
.SUBCKT NH5751 A G K
XV1 A G K TRIODENH
+PARAMS: LIP= 1.5 LIF= 0.000016 RAF= 0.075772 RAS= 1 CDO=-0.53056 
+ RAP= 0.131285 ERP= 1.5 
+ MU0= 62.94685 MUR=-0.0111 EMC= 0.00000142 
+ GCO=-0.2 GCF= 0.00001 
+ CGA=1.40E-12 CGK=1.40E-12 CAK=4.50E-13
.ENDS

